/*++

INTEL CONFIDENTIAL
Copyright 2007-2018 Intel Corporation All Rights Reserved.

The source code contained or described herein and all documents
related to the source code ("Material") are owned by Intel Corporation
or its suppliers or licensors. Title to the Material remains with
Intel Corporation or its suppliers and licensors. The Material
contains trade secrets and proprietary and confidential information of
Intel or its suppliers and licensors. The Material is protected by
worldwide copyright and trade secret laws and treaty provisions. No
part of the Material may be used, copied, reproduced, modified,
published, uploaded, posted, transmitted, distributed, or disclosed in
any way without Intel's prior express written permission.

No license under any patent, copyright, trade secret or other
intellectual property right is granted to or conferred upon you by
disclosure or delivery of the Materials, either expressly, by
implication, inducement, estoppel or otherwise. Any license under such
intellectual property rights must be express and approved by Intel in
writing.

File Name:
FWUpdateLib.h

Abstract:
Handles full and partial firmware updates via HECI.

--*/

#ifndef __FW_UPDATE_LIB_DEPRECATED_H__
#define __FW_UPDATE_LIB_DEPRECATED_H__

#if defined(__GNUC__) || defined(__clang__)
#define DEPRECATED __attribute__((deprecated))
#elif defined(_MSC_VER)
#define DEPRECATED __declspec(deprecated)
#else
#pragma message("WARNING: You need to implement DEPRECATED for this compiler")
#define DEPRECATED
#endif

#define FPT_PARTITION_NAME_FPT      0x54504624

typedef struct _UPDATE_FLAGS_LIB
{
    UINT32 Reserved          :1;       // Previously indicate restore point
    UINT32 RestartOperation  :1;       // If set indicate restart operation, like lost hard drive etc...
    UINT32 UserRollback      :1;       // indicates user has initiated a rollback
    UINT32 Reserve           :29;      //
} UPDATE_FLAGS_LIB;

// Used by the tool to perform FULL FW update
typedef enum _UPDATE_TYPE
{
    DOWNGRADE_SUCCESS = 0,
    DOWNGRADE_FAILURE,
    SAMEVERSION_SUCCESS,
    SAMEVERSION_FAILURE,
    UPGRADE_SUCCESS,
    UPGRADE_PROMPT
} UPDATE_TYPE;

// Image type to validate the binary sent to update
// For Full Update - only FULL image type is valid
// For Partial Update - only FULL and PARTIAL image type is valid
// FULL Image => Image with Flash Partition Table, FTPR, and NFTPR
// PARTIAL Image => Image with no Flash Partition Table or FTPR or NFTPR,
//                        only WCOD or LOCL
typedef enum _IMAGE_TYPE
{
    FULL = 0,
    PARTIAL,
    RESTORE,
    INVALID
} IMAGE_TYPE;

typedef enum _SKU_TYPE
{
   SKU_1_5_MB = 0,
   SKU_5_MB,
   SKU_RESERVED,
   SKU_INVALID
} SKU_TYPE;

typedef enum _PCH_SKU
{
   PCH_SKU_H = 0,
   PCH_SKU_LP,
   PCH_SKU_N,
   PCH_SKU_INVALID
} PCH_SKU;

typedef enum _FWUPD_POWER_SOURCE
{
    FWUPD_POWER_SOURCE_AC  = 1,  ///< AC Power source
    FWUPD_POWER_SOURCE_DC  = 2,  ///< DC Power source
    FWUPD_POWER_SOURCE_UNKOWN    ///< Unable to determine power source
} FWUPD_POWER_SOURCE;

//Used by the tool to retrieve FW version information
typedef struct {
    UINT16 Major;
    UINT16 Minor;
    UINT16 Hotfix;
    UINT16 Build;
} VersionLib;

// Should be used by both tool and UNS to retrieve the Updated UPV version
typedef struct _IPU_UPDATED_INFO
{
    UINT32 UpdatedUpvVer; //Version from the update image file that is for updating IPU
    UINT32 Reserved[4];
} IPU_UPDATED_INFO;

#ifdef __cplusplus
extern "C" {
#endif

//API used only by the tool
//    FWUPD_INTERNAL_START_MARKER
//    Do not delete this marker. A script uses this marker to remove the below _Temp and IFR API definitions
//  before copying the header to the FWUpdatePKG distribution.
#ifdef _FWUPDATE_DLL
#define DllExport __declspec(dllexport)
#else
#define DllExport
#endif
//  Do not delete this marker. A script uses this marker to remove the above _Temp and IFR API definitions
//  before copying the header to the FWUpdatePKG distribution.
//    FWUPD_INTERNAL_END_MARKER

#if defined(EFI) || defined(DOS) || defined(_RELEASE_LIB) || defined(__linux__)
#define TCHAR char
#endif

/**++
********************************************************************************
*
** FUNCTION:
**   GetPchSKU
**
** DESCRIPTION:
**   This function retrieve the platform SKU.
**
** ARGUMENTS:
**    sku    - UINT32 from the user to be populated by the function
**    sku can get 3 possible values:
**      0    H
**      1    LP
**      2    N
**      3    Unknown SKU
** Returns 0 on success

**
********************************************************************************
--*/
DEPRECATED DllExport UINT32 GetPchSKU(UINT32 *sku);

/**++
********************************************************************************
*
** FUNCTION:
**   GetOemID
**
** DESCRIPTION:
**   This function retrieve the Return FW OEM ID.
**
** ARGUMENTS:
**    pOemIdStr - Pointer to the char array that will contain the string
** Returns 0 on success
**
********************************************************************************
--*/
DEPRECATED DllExport UINT32 GetOemID (char *pOemIdStr, UINT32 bufferSize);

/**++
********************************************************************************
*
** FUNCTION:
**   GetFwType
**
** DESCRIPTION:
**   This function retrieve the FW type
**
** ARGUMENTS:
**    fwType - UINT32 from the user to be populated by the function
**    fwType can get 4 possible values:
**      0    for 1.5M SKU image (consumer)
**      1    for 5M SKU image (corporate)
**      2    reserved
**      3    Unknown SKU
** Returns 0 on success
**
********************************************************************************
--*/
DEPRECATED DllExport UINT32 GetFwType(UINT32 *fwType);

DEPRECATED DllExport UINT32 GetInterfaces(UINT16 *interfaces);

DEPRECATED DllExport UINT32 GetLastStatus(UINT32 *lastStatus);

DEPRECATED DllExport UINT32 GetLastUpdateResetType(UINT32 *lastResetType);

DEPRECATED DllExport int SaveRestorePoint(const char * ImageFileLib);

DEPRECATED DllExport int GetFwVersion(const TCHAR *imageFileLib,
                           unsigned short *major,
                           unsigned short *minor,
                           unsigned short *hotfix,
                           unsigned short *build);

DEPRECATED DllExport UINT32 FwUpdateFull(
    const char*      ImageFile,
    char*            _pwd,
    int              _forceResetLib,
    UINT32           UpdateEnvironment,
    _UUID            OemID,
    UPDATE_FLAGS_LIB update_flags,
    void(*func)(UINT32, UINT32));

DEPRECATED DllExport UINT32 CheckPolicy(
    const TCHAR*  ImageFileLib,
    int          AllowSV,
    UPDATE_TYPE* Upd_Type,
    VersionLib*  ver);

DEPRECATED DllExport UINT32 CheckPolicyBuffer(
    unsigned char* buffer,
    int            bufferLength,
    int            AllowSV,
    UPDATE_TYPE*   Upd_Type,
    VersionLib*    ver);

DEPRECATED DllExport BOOL VerifyOemId(_UUID id);

DEPRECATED DllExport UINT32 IsRestorePointImage(
    const TCHAR *ImageFileLib,
    UINT32*      IsRestoreImage);

//APIs used by both tool and UNS
DEPRECATED DllExport UINT32 GetIpuPartitionAttributes(
    FWU_GET_IPU_PT_ATTRB_MSG_REPLY *FwuGetIpuAttrbMsgInfo);

DEPRECATED DllExport UINT32 GetExtendedIpuPartitionAttributes(
    FWU_GET_IPU_PT_ATTRB_MSG_REPLY* FwuGetIpuAttrbMsgInfo,
    UINT32 updateOp);

DEPRECATED DllExport UINT32 GetFwUpdateInfoStatus(
    FWU_INFO_FLAGS *StatusFlags);

DEPRECATED DllExport UINT32 FwUpdatePartial(
    const TCHAR* ImageFileName,
    UINT32       PartitionID,
    UINT32       Flags,
    IPU_UPDATED_INFO* IpuUpdatedInfo,
    char*        _pwd,
    UINT32       UpdateEnvironment,
    _UUID        OemID,
    UPDATE_FLAGS_LIB  update_flags,
    void(*func)(UINT32, UINT32));

DEPRECATED DllExport UINT32 FwUpdateCheckPowerSource(
    FWUPD_POWER_SOURCE* PowerSource);

DEPRECATED DllExport UINT32 FWUpdate_QueryStatus_Get_Response(
    UINT32* UpdateStatus,
    UINT32 *TotalStages,
    UINT32* PercentWritten,
    UINT32* LastUpdateStatus,
    UINT32* LastResetType);

DEPRECATED DllExport UINT32 FwUpdateRestore(
    const char*      ImageFile,
    char*            _pwd,
    int              _forceResetLib,
    UINT32           UpdateEnvironment,
    _UUID            OemID,
    UPDATE_FLAGS_LIB update_flags,
    void(*func)(UINT32, UINT32));

DEPRECATED DllExport UINT32 FwUpdateFullBuffer(
    unsigned char*  buffer,
    UINT32           bufferLength,
    char*            _pwd,
    int              _forceResetLib,
    UINT32           UpdateEnvironment,
    _UUID            OemID,
    UPDATE_FLAGS_LIB update_flags,
    void(*func)(UINT32, UINT32));

DEPRECATED DllExport UINT32 FwUpdatePartialBuffer(
    unsigned char*    buffer,
    UINT32            bufferLength,
    UINT32            PartitionID,
    UINT32            Flags,
    IPU_UPDATED_INFO *IpuUpdatedInfo,
    char*             _pwd,
    UINT32            UpdateEnvironment,
    _UUID             OemID,
    UPDATE_FLAGS_LIB  update_flags,
    void(*func)(UINT32, UINT32));

DEPRECATED DllExport UINT32 FwUpdateRestoreBuffer(
    unsigned char* buffer,
    UINT32         bufferLength,
    char*          _pwd,
    INT32          _forceResetLib,
    UINT32         UpdateEnvironment,
    _UUID          OemID,
    UPDATE_FLAGS_LIB update_flags,
    void(*func)(UINT32, UINT32));

DEPRECATED int GetPartVersion(UINT32 partID, UINT16 *major, UINT16 *minor, UINT16 *hotfix, UINT16 *build);
DEPRECATED int GetPartVendorID(UINT32 partID, UINT32 *vendor_id);

//    FWUPD_INTERNAL_START_MARKER
//    Do not delete this marker. A script uses this marker to remove the below _Temp and IFR API definitions
//  before copying the header to the FWUpdatePKG distribution.
#ifndef _RELEASE_LIB
//A temporary API for testing only (will be removed from the final Library
DEPRECATED DllExport UINT32 FwUpdatePartialWithInstanceId(
    const TCHAR*      ImageFileName,
    UINT32            PartitionID,
    UINT32            InstID,
    UINT32            Flags,
    IPU_UPDATED_INFO* IpuUpdatedInfo,
    UPDATE_FLAGS_LIB  update_flags,
    void(*func)(UINT32, UINT32));

DEPRECATED DllExport UINT32 FwUpdatePartialWithInstanceIdBuffer(
    unsigned char* buffer,
    UINT32         bufferLength,
    UINT32         PartitionID,
    UINT32         InstID,
    UINT32         Flags,
    IPU_UPDATED_INFO* IpuUpdatedInfo,
    UPDATE_FLAGS_LIB  update_flags,
    void(*func)(UINT32, UINT32));
#endif /* !_RELEASE_LIB */

#undef DllExport


//    Do not delete this marker. A script uses this marker to remove the above _Temp and IFR API definitions
//  before copying the header to the FWUpdatePKG distribution.
//    FWUPD_INTERNAL_END_MARKER

#ifdef __cplusplus
}
#endif

#endif
/* vim: set ts=4 sw=4 tw=0 noet : */
